<!doctype html>
<html>

<head>
    <title>Line Chart</title>
    <script src="dist/Chart.min.js"></script>
    <script src="samples/utils.js"></script>
    <style>
    canvas
    {
        -moz-user-select: none;
        -webkit-user-select: none;
        -ms-user-select: none;
    }
    </style>
</head>

<body>
    <div style="display: none;">
        <b>REPORTE TOTAL DE VENDEDORES</b><BR>
        SELECT
  D.Vendedor,
  A.MontoTotal P_201909,
  B.MontoTotal P_201908,
  ROUND( ( ( A.MontoTotal / B.MontoTotal ) * 100 ) - 100, 2 ) PorcVariacion
FROM VTA_Documento D
  LEFT JOIN
  (
    SELECT Vendedor, SUM(MontoTotal) MontoTotal
    FROM VTA_Documento
    where 1=1 and Periodo='201908' and Estado='CE'
    group by Vendedor
  ) A ON A.Vendedor=D.Vendedor
  LEFT JOIN
  (
    SELECT Vendedor, SUM(MontoTotal) MontoTotal
    FROM VTA_Documento
    where 1=1 and Periodo='201907' and Estado='CE'
    group by Vendedor
  ) B ON B.Vendedor=D.Vendedor
where 1=1
group by D.Vendedor
ORDER BY 2 DESC;
    </div>
    <br>
    <div style="width:80%;">
        <canvas id="canvas"></canvas>
    </div>
    <br>

<script>
//var MONTHS = ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Setiembre', 'Octubre', 'Noviembre', 'Diciembre'];
var VENDEDOR = ['echambi', 'raul.mamani', 'vmamani', 'melissa', 'thalia'];
var color = Chart.helpers.color;
var config = 
{
    type: 'bar',
    data: 
    {
        labels: VENDEDOR,
        datasets: 
        [
            {
                label: 'Mes Actual',
                backgroundColor: color( window.chartColors.blue ).alpha( 0.5 ).rgbString(),
                borderColor: window.chartColors.blue,
                data: 
                [
                    245388.49,
                    230471.93,
                    126733.36,
                    83557.00,
                    64613.78,
                ],
                fill: false
            },
            {
                label: 'Mes Anterior',
                backgroundColor: color( window.chartColors.red ).alpha( 0.5 ).rgbString(),
                borderColor: window.chartColors.red,
                data: 
                [
                    248177.24,
                    230877.75,
                    141537.52,
                    91132.73,
                    79872.30,
                ],
                fill: false
            }
        ]
    },
    options: 
    {
        responsive: true,
        title: 
        {
            display: true,
            text: 'Top 5 Vendedores del Mes'
        },
        tooltips: 
        {
            mode: 'index',
            intersect: false,
        },
        hover: 
        {
            mode: 'nearest',
            intersect: true
        },
        scales: 
        {
            xAxes: 
            [
                {
                    display: true,
                    scaleLabel: 
                    {
                        display: true,
                        labelString: 'VENDEDORES'
                    }
                }
            ],
            yAxes: 
            [
                {
                    display: true,
                    scaleLabel: 
                    {
                        display: true,
                        labelString: 'MONTO'
                    }
                }
            ]
        }
    }
};

var ctx = document.getElementById( 'canvas' ).getContext( '2d' );
window.myLine = new Chart( ctx, config );
</script>

    <DIV style="display: none;">
        //ventas por familia de producto
        SELECT I.IdItem, I.IdLinea, L.Descripcion, ROUND( SUM(MontoTotal), 2 ) MontoTotal
        FROM VTA_Documento C
          LEFT JOIN VTA_DocumentoDetalle D ON C.IdTipoDocumento=D.IdTipoDocumento AND C.IdCompania=D.IdCompania AND  C.NumeroDocumento=D.NumeroDocumento
            LEFT JOIN ALM_ItemMast I ON D.ItemCodigo=I.IdItem
              LEFT JOIN MST_ClaseLinea L ON I.IdLinea=L.IdLinea
        where 1=1
        and C.Periodo='201908'
        and C.Estado='CE'
        GROUP BY I.IdLinea
        ORDER BY 4 DESC;
    </DIV>
    <div style="width:80%;">
        <canvas id="canvas2"></canvas>
    </div>
    <br>

<script>
//var MONTHS = ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Setiembre', 'Octubre', 'Noviembre', 'Diciembre'];
var randomScalingFactor = function() 
{
    return Math.round( Math.random() * 100 );
};
var config = 
{
    type: 'pie',
    data: 
    {
        datasets: 
        [
            {
                data: 
                [
                    11254161.80,
                    5622365.68,
                    2763927.23,
                    1948636.72,
                    1162527.11,
                    1073220.25,
                ],
                backgroundColor: 
                [
                    window.chartColors.red,
                    window.chartColors.orange,
                    window.chartColors.yellow,
                    window.chartColors.green,
                    window.chartColors.blue,
                    window.chartColors.purple,
                ],
                label: 'Dataset 1'
            }
        ],
        labels: 
        [
            'CAJA 2___S/. 11,254,161.80',
            'FRASCO 2_S/. 5,622,365.68',
            'BLISTER__S/. 2,763,927.23',
            'UNIDAD___S/. 1,948,636.72',
            'SOBRES___S/. 1,162,527.11',
            'JARABE___S/. 1,073,220.25'
        ]
    },
    options: 
    {
        responsive: true,
        legend: 
        {
            position: 'left',
        },
        title: 
        {
            display: true,
            text: 'Ventas por Familia de Producto'
        },
        tooltips: 
        {
            mode: 'index',
            intersect: true,
            callbacks: {
                label: function(tooltipItem, data)
                {
                    var allData = data.datasets[tooltipItem.datasetIndex].data;
                    var tooltipLabel = data.labels[tooltipItem.index];
                    var tooltipData = allData[tooltipItem.index];
                    var total = 0;
                    for ( var i in allData )
                    {
                        total += allData[i];
                    }
                    var tooltipPercentage = Math.round( ( tooltipData / total ) * 100 );
                    //return tooltipLabel + ': ' + tooltipData + ' ( ' + tooltipPercentage + '% )';
                    return tooltipLabel + ' :  ( ' + tooltipPercentage + ' % )';
                }
            }
        },
        /*
        hover: 
        {
            mode: 'nearest',
            intersect: true
        },
        */
        animation: 
        {
            animateRotate: true,
            animateScale: true
        }
        /*
        scales: 
        {
            xAxes: 
            [
                {
                    display: true,
                    scaleLabel: 
                    {
                        display: true,
                        labelString: 'VENDEDORES'
                    }
                }
            ],
            yAxes: 
            [
                {
                    display: true,
                    scaleLabel: 
                    {
                        display: true,
                        labelString: 'MONTO'
                    }
                }
            ]
        }
        */
    }
};

var ctx = document.getElementById( 'canvas2' ).getContext( '2d' );
window.myLine = new Chart( ctx, config );

Chart.plugins.register
(
    {
        afterDatasetsDraw: function( chartInstance, easing ) 
        {
            // To only draw at the end of animation, check for easing === 1
            var ctx = chartInstance.chart.ctx;
            chartInstance.data.datasets.forEach
            (
                function( dataset, i ) 
                {
                    var meta = chartInstance.getDatasetMeta( i );
                    if ( meta.type == "pie" ) 
                    {
                        if ( !meta.hidden ) 
                        {
                            meta.data.forEach
                            (
                                function( element, index ) 
                                {
                                    console.log( arguments );
                                    // Draw the text in black, with the specified font
                                    ctx.fillStyle = '#ffff';
                                    var fontSize = 16;
                                    var fontStyle = 'normal';
                                    var fontFamily = 'Helvetica Neue';
                                    ctx.font = Chart.helpers.fontString( fontSize, fontStyle, fontFamily );
                                    // Just naively convert to string for now
                                    var dataString = dataset.data[index].toString();
                                    // Make sure alignment settings are correct
                                    ctx.textAlign = 'center';
                                    ctx.textBaseline = 'middle';
                                    var padding = 5;
                                    var position = element.tooltipPosition();
                                    var tooltipPercentage = Math.round( ( parseFloat( dataString ) / 23824838.79 ) * 100 );
                                    //ctx.fillText( dataString + '%', position.x, position.y - ( fontSize / 2 ) - padding );
                                    ctx.fillText( tooltipPercentage + '%', position.x, position.y - ( fontSize / 2 ) - padding );
                                }
                            );
                        }
                    }
                }
            );
        }
    }
);

</script>

    <DIV style="display: none;">
        //ventas por producto
        SELECT I.IdItem, I.DescripcionCompleta, ROUND( SUM(MontoTotal), 2 ) MontoTotal
        FROM VTA_Documento C
          LEFT JOIN VTA_DocumentoDetalle D ON C.IdTipoDocumento=D.IdTipoDocumento AND C.IdCompania=D.IdCompania AND  C.NumeroDocumento=D.NumeroDocumento
            LEFT JOIN ALM_ItemMast I ON D.ItemCodigo=I.IdItem
        where 1=1
        and C.Periodo='201908'
        and C.Estado='CE'
        GROUP BY I.IdItem
        ORDER BY 3 DESC;
    </DIV>
    <div style="width:80%;">
        <canvas id="canvas3"></canvas>
    </div>
    <br>

    <script>
        function colorize(opaque, context) {
            var value = context.dataset.data[context.dataIndex];
            var x = value.x / 1000;
            var y = value.y / 100;
            var r = x < 0 && y < 0 ? 250 : x < 0 ? 150 : y < 0 ? 50 : 0;
            var g = x < 0 && y < 0 ? 0 : x < 0 ? 50 : y < 0 ? 150 : 250;
            var b = x < 0 && y < 0 ? 0 : x > 0 && y > 0 ? 250 : 150;
            var a = opaque ? 1 : 0.5 * value.v / 1000;

            return 'rgba(' + r + ',' + g + ',' + b + ',' + a + ')';
        }
        var MIN_XY = 0;
        var MAX_XY = 500;
        var utils = Samples.utils;
        utils.srand( 500 );
new Chart
(
    document.getElementById( "canvas3" ), 
    {
        type: 'bubble',
        data: 
        {
            labels: "XXX",
            datasets: 
            [
                {
                    label: ["IBUPROFENO 100MG/5ML X 120ML JBE GENFAR"],
                    backgroundColor: "rgba(255,221,50,0.5)",
                    borderColor: "rgba(255,221,50,1)",
                    title: "Monto 183,611.88",
                    data: 
                    [
                        {
                            x: Math.round( utils.rand( MIN_XY, MAX_XY ), 0 ),
                            y: 183611.88,
                            r: utils.rand( 5, 20 )
                        }
                    ]
                },
                {
                    label: ["NAPROXENO SODICO 550MG X 100 TAB."],
                    backgroundColor: "rgba(60,186,159,0.2)",
                    borderColor: "rgba(60,186,159,1)",
                    title: "Monto 151,843.49",
                    data: 
                    [
                        {
                            x: Math.round( utils.rand( MIN_XY, MAX_XY ), 0 ),
                            y: 151843.49,
                            r: utils.rand( 5, 20 )
                        }
                    ]
                },
                {
                    label: ["PANADOL ANTIGRIPAL NF CJA X 52 SOBRES"],
                    backgroundColor: "rgba(0,0,0,0.2)",
                    borderColor: "#000",
                    title: "Monto 150,299.17",
                    data: 
                    [
                        {
                            x: Math.round( utils.rand( MIN_XY, MAX_XY ), 0 ),
                            y: 150299.17,
                            r: utils.rand( 5, 20 )
                        }
                    ]
                },
                {
                    label: ["FRAMIDEX GTAS FCO X 2.5 ML"],
                    backgroundColor: "rgba(193,46,12,0.2)",
                    borderColor: "rgba(193,46,12,1)",
                    title: "Monto 143,767.97",
                    data: 
                    [
                        {
                            x: Math.round( utils.rand( MIN_XY, MAX_XY ), 0 ),
                            y: 143767.97,
                            r: utils.rand( 5, 20 )
                        }
                    ]
                }
            ]
        },
        options: 
        {
            aspectRatio: 1,
            responsive: true,
            legend: 
            {
                position: 'top',
            },
            title: 
            {
                display: true,
                text: 'Ventas por Producto'
            },
            elements: {
                point: {
                    backgroundColor: colorize.bind(null, false),

                    borderColor: colorize.bind(null, true),

                    borderWidth: function(context) {
                        return Math.min(Math.max(1, context.datasetIndex + 1), 8);
                    },

                    hoverBackgroundColor: 'transparent',

                    hoverBorderColor: function(context) {
                        return utils.color(context.datasetIndex);
                    },

                    hoverBorderWidth: function(context) {
                        var value = context.dataset.data[context.dataIndex];
                        return Math.round( 8 * value.v / 1000 );
                    },

                    radius: function(context) {
                        var value = context.dataset.data[context.dataIndex];
                        var size = context.chart.width;
                        var base = Math.abs(value.v) / 1000;
                        return (size / 24) * base;
                    }
                }
            },
            /*tooltips: 
            {
                mode: 'index',
                intersect: true,
                callbacks: {
                    label: function(tooltipItem, data)
                    {
                        var allData = data.datasets[tooltipItem.datasetIndex].data;
                        var tooltipLabel = data.labels[tooltipItem.index];
                        var tooltipData = allData[tooltipItem.index];
                        var total = 0;
                        for ( var i in allData )
                        {
                            total += allData[i];
                        }
                        var tooltipPercentage = Math.round( ( tooltipData / total ) * 100 );
                        //return tooltipLabel + ': ' + tooltipData + ' ( ' + tooltipPercentage + '% )';
                        return tooltipLabel + ' :  ( ' + tooltipPercentage + '% )';
                    }
                }
            },*/
            scales: 
            {
                yAxes: 
                [
                    {
                        scaleLabel: 
                        {
                            display: true,
                            labelString: "Ventas"
                        }
                    }
                ],
                xAxes: 
                [
                    {
                        scaleLabel: 
                        {
                            display: false,
                            labelString: ""
                        }
                    }
                ]
            }
        }
    }
);

Chart.plugins.register
(
    {
        afterDatasetsDraw: function( chart, easing ) 
        {
            var ctx = chart.ctx;

            chart.data.datasets.forEach
            (
                function( dataset, i ) 
                {
                    var meta = chart.getDatasetMeta( i );
                    if ( meta.type == "bubble" ) 
                    {
                        //exclude scatter
                        meta.data.forEach
                        (
                            function( element, index ) 
                            {
                                // Draw the text in black, with the specified font
                                ctx.fillStyle = 'rgb(0, 0, 0)';
                                var fontSize = 13;
                                var fontStyle = 'normal';
                                var fontFamily = 'Helvetica Neue';
                                ctx.font = Chart.helpers.fontString( fontSize, fontStyle, fontFamily );

                                // Just naively convert to string for now
                                var dataString = dataset.data[index].toString();
                                // Make sure alignment settings are correct
                                ctx.textAlign = 'center';
                                ctx.textBaseline = 'middle';

                                var padding = 15;
                                var position = element.tooltipPosition();
                                //ctx.fillText( dataset.title, position.x, position.y - ( fontSize / 2 ) - padding );
                                ctx.fillText( dataset.title, position.x, position.y - ( fontSize / 2 ) - padding );
                            }
                        );
                    } //if
                }
            );
        }
    }
);
    </script>

</body>